﻿using System;
using System.Diagnostics;
using System.Xml.Serialization;
using System.Collections;
using System.Xml.Schema;
using System.ComponentModel;
using System.IO;
using System.Text;
using System.Xml;
using System.Collections.Generic;

namespace Service_Manager.CIS.Schema
{
    #region Base entity class
    public partial class EntityBase<T>

    {

        private static XmlSerializer serializer;

        private static XmlSerializer Serializer
        {
            get
            {
                if ((serializer == null))
                {
                    serializer = new XmlSerializerFactory().CreateSerializer(typeof(T));
                }
                return serializer;
            }
        }

        #region Serialize/Deserialize
        /// <summary>
        /// Serializes current EntityBase object into an XML string
        /// </summary>
        /// <returns>string XML value</returns>
        public virtual string Serialize(System.Text.Encoding encoding)
        {
            System.IO.StreamReader streamReader = null;
            System.IO.MemoryStream memoryStream = null;
            try
            {
                memoryStream = new System.IO.MemoryStream();
                System.Xml.XmlWriterSettings xmlWriterSettings = new System.Xml.XmlWriterSettings();
                xmlWriterSettings.Encoding = encoding;
                System.Xml.XmlWriter xmlWriter = XmlWriter.Create(memoryStream, xmlWriterSettings);

                System.Xml.Serialization.XmlSerializerNamespaces ns = new System.Xml.Serialization.XmlSerializerNamespaces();
                ns.Add("tns", "http://www.apis-it.hr/fin/2012/types/f73");
                ns.Add("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                Serializer.Serialize(xmlWriter, this, ns);

                //Serializer.Serialize(xmlWriter, this);
                memoryStream.Seek(0, System.IO.SeekOrigin.Begin);
                streamReader = new System.IO.StreamReader(memoryStream, encoding);
                return streamReader.ReadToEnd();
            }
            finally
            {
                if ((streamReader != null))
                {
                    streamReader.Dispose();
                }
                if ((memoryStream != null))
                {
                    memoryStream.Dispose();
                }
            }
        }

        public virtual string Serialize()
        {
            return Serialize(System.Text.Encoding.UTF8);
        }

        /// <summary>
        /// Deserializes workflow markup into an EntityBase object
        /// </summary>
        /// <param name="input">string workflow markup to deserialize</param>
        /// <param name="obj">Output EntityBase object</param>
        /// <param name="exception">output Exception value if deserialize failed</param>
        /// <returns>true if this Serializer can deserialize the object; otherwise, false</returns>
        public static bool Deserialize(string input, out T obj, out System.Exception exception)
        {
            exception = null;
            obj = default(T);
            try
            {
                obj = Deserialize(input);
                return true;
            }
            catch (System.Exception ex)
            {
                exception = ex;
                return false;
            }
        }

        public static bool Deserialize(string input, out T obj)
        {
            System.Exception exception = null;
            return Deserialize(input, out obj, out exception);
        }

        public static T Deserialize(string input)
        {
            System.IO.StringReader stringReader = null;
            try
            {
                stringReader = new System.IO.StringReader(input);
                return ((T)(Serializer.Deserialize(System.Xml.XmlReader.Create(stringReader))));
            }
            finally
            {
                if ((stringReader != null))
                {
                    stringReader.Dispose();
                }
            }
        }

        public static T Deserialize(System.IO.Stream s)
        {
            return ((T)(Serializer.Deserialize(s)));
        }
        #endregion

        /// <summary>
        /// Serializes current EntityBase object into file
        /// </summary>
        /// <param name="fileName">full path of outupt xml file</param>
        /// <param name="exception">output Exception value if failed</param>
        /// <returns>true if can serialize and save into file; otherwise, false</returns>
        public virtual bool SaveToFile(string fileName, System.Text.Encoding encoding, out System.Exception exception)
        {
            exception = null;
            try
            {
                SaveToFile(fileName, encoding);
                return true;
            }
            catch (System.Exception e)
            {
                exception = e;
                return false;
            }
        }

        public virtual bool SaveToFile(string fileName, out System.Exception exception)
        {
            return SaveToFile(fileName, System.Text.Encoding.UTF8, out exception);
        }

        public virtual void SaveToFile(string fileName)
        {
            SaveToFile(fileName, System.Text.Encoding.UTF8);
        }

        public virtual void SaveToFile(string fileName, System.Text.Encoding encoding)
        {
            System.IO.StreamWriter streamWriter = null;
            try
            {
                string xmlString = Serialize(encoding);
                streamWriter = new System.IO.StreamWriter(fileName, false, System.Text.Encoding.UTF8);
                streamWriter.WriteLine(xmlString);
                streamWriter.Close();
            }
            finally
            {
                if ((streamWriter != null))
                {
                    streamWriter.Dispose();
                }
            }
        }

        /// <summary>
        /// Deserializes xml markup from file into an EntityBase object
        /// </summary>
        /// <param name="fileName">string xml file to load and deserialize</param>
        /// <param name="obj">Output EntityBase object</param>
        /// <param name="exception">output Exception value if deserialize failed</param>
        /// <returns>true if this Serializer can deserialize the object; otherwise, false</returns>
        public static bool LoadFromFile(string fileName, System.Text.Encoding encoding, out T obj, out System.Exception exception)
        {
            exception = null;
            obj = default(T);
            try
            {
                obj = LoadFromFile(fileName, encoding);
                return true;
            }
            catch (System.Exception ex)
            {
                exception = ex;
                return false;
            }
        }

        public static bool LoadFromFile(string fileName, out T obj, out System.Exception exception)
        {
            return LoadFromFile(fileName, System.Text.Encoding.UTF8, out obj, out exception);
        }

        public static bool LoadFromFile(string fileName, out T obj)
        {
            System.Exception exception = null;
            return LoadFromFile(fileName, out obj, out exception);
        }

        public static T LoadFromFile(string fileName)
        {
            return LoadFromFile(fileName, System.Text.Encoding.UTF8);
        }

        public static T LoadFromFile(string fileName, System.Text.Encoding encoding)
        {
            System.IO.FileStream file = null;
            System.IO.StreamReader sr = null;
            try
            {
                file = new System.IO.FileStream(fileName, FileMode.Open, FileAccess.Read);
                sr = new System.IO.StreamReader(file, encoding);
                string xmlString = sr.ReadToEnd();
                sr.Close();
                file.Close();
                return Deserialize(xmlString);
            }
            finally
            {
                if ((file != null))
                {
                    file.Dispose();
                }
                if ((sr != null))
                {
                    sr.Dispose();
                }
            }
        }
    }
    #endregion

    /// <summary>
    /// Poruka prema web servisu za zaprimanje racuna.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = false)]
    public partial class RacunZahtjev : EntityBase<RacunZahtjev>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private ZaglavljeType _zaglavlje;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private RacunType _racun;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _id;

        /// <summary>
        /// RacunZahtjev class constructor
        /// </summary>
        public RacunZahtjev()
        {
            this._racun = new RacunType();
            this._zaglavlje = new ZaglavljeType();
        }

        public ZaglavljeType Zaglavlje
        {
            get
            {
                return this._zaglavlje;
            }
            set
            {
                this._zaglavlje = value;
            }
        }

        public RacunType Racun
        {
            get
            {
                return this._racun;
            }
            set
            {
                this._racun = value;
            }
        }

        /// <summary>
        /// Atribut za potrebe digitalnog potpisa, u njega se stavlja referentni na koji se referencira digitalni potpis.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string Id
        {
            get
            {
                return this._id;
            }
            set
            {
                this._id = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class ZaglavljeType : EntityBase<ZaglavljeType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _idPoruke;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _datumVrijeme;

        /// <summary>
        /// Odabrati:
        /// Version 1 (MAC address) - ne koristiti
        /// Version 2 (DCE Security) - bazirano vremenskoj komponenti i
        /// domeni
        /// Version 3 (MD5 hash) - osnovni podaci generirano u
        /// ovisnosti
        /// o URLu, domeni i sl.
        /// Version 4 (random) - ne govori
        /// mnogo
        /// Version 5 (SHA-1 hash) - preferirano umjesto V3
        /// </summary>
        public string IdPoruke
        {
            get
            {
                return this._idPoruke;
            }
            set
            {
                this._idPoruke = value;
            }
        }

        /// <summary>
        /// Datum i vrijeme slanja poruke.
        /// </summary>
        public string DatumVrijeme
        {
            get
            {
                return this._datumVrijeme;
            }
            set
            {
                this._datumVrijeme = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class NaknadaType : EntityBase<NaknadaType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _nazivN;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _iznosN;

        /// <summary>
        /// Naziv naknade.
        /// </summary>
        public string NazivN
        {
            get
            {
                return this._nazivN;
            }
            set
            {
                this._nazivN = value;
            }
        }

        /// <summary>
        /// Iznos naknade.
        /// </summary>
        public string IznosN
        {
            get
            {
                return this._iznosN;
            }
            set
            {
                this._iznosN = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class PorezOstaloType : EntityBase<PorezOstaloType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _naziv;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _stopa;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _osnovica;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _iznos;

        /// <summary>
        /// Naziv poreza za koji se salju podaci.
        /// </summary>
        public string Naziv
        {
            get
            {
                return this._naziv;
            }
            set
            {
                this._naziv = value;
            }
        }

        /// <summary>
        /// Iznos porezne stope.
        /// </summary>
        public string Stopa
        {
            get
            {
                return this._stopa;
            }
            set
            {
                this._stopa = value;
            }
        }

        /// <summary>
        /// Iznos osnovice.
        /// </summary>
        public string Osnovica
        {
            get
            {
                return this._osnovica;
            }
            set
            {
                this._osnovica = value;
            }
        }

        /// <summary>
        /// Iznos poreza.
        /// </summary>
        public string Iznos
        {
            get
            {
                return this._iznos;
            }
            set
            {
                this._iznos = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class PorezType : EntityBase<PorezType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _stopa;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _osnovica;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _iznos;

        /// <summary>
        /// Iznos porezne stope.
        /// </summary>
        public string Stopa
        {
            get
            {
                return this._stopa;
            }
            set
            {
                this._stopa = value;
            }
        }

        /// <summary>
        /// Iznos osnovice.
        /// </summary>
        public string Osnovica
        {
            get
            {
                return this._osnovica;
            }
            set
            {
                this._osnovica = value;
            }
        }

        /// <summary>
        /// Iznos poreza.
        /// </summary>
        public string Iznos
        {
            get
            {
                return this._iznos;
            }
            set
            {
                this._iznos = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class BrojRacunaType : EntityBase<BrojRacunaType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _brOznRac;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _oznPosPr;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _oznNapUr;

        /// <summary>
        /// Brojcana oznaka racuna.
        /// </summary>
        public string BrOznRac
        {
            get
            {
                return this._brOznRac;
            }
            set
            {
                this._brOznRac = value;
            }
        }

        /// <summary>
        /// Oznaka poslovnog prostora.
        /// </summary>
        public string OznPosPr
        {
            get
            {
                return this._oznPosPr;
            }
            set
            {
                this._oznPosPr = value;
            }
        }

        /// <summary>
        /// Oznaka naplatnog uredjaja.
        /// </summary>
        public string OznNapUr
        {
            get
            {
                return this._oznNapUr;
            }
            set
            {
                this._oznNapUr = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class RacunType : EntityBase<RacunType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _oib;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private bool _uSustPdv;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _datVrijeme;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private OznakaSlijednostiType _oznSlijed;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private BrojRacunaType _brRac;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<PorezType> _pdv;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<PorezType> _pnp;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<PorezOstaloType> _ostaliPor;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _iznosOslobPdv;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _iznosMarza;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _iznosNePodlOpor;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<NaknadaType> _naknade;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _iznosUkupno;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private NacinPlacanjaType _nacinPlac;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _oibOper;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _zastKod;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private bool _nakDost;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _paragonBrRac;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _specNamj;

        /// <summary>
        /// RacunType class constructor
        /// </summary>
        public RacunType()
        {
            this._naknade = new List<NaknadaType>();
            this._ostaliPor = new List<PorezOstaloType>();
            this._pnp = new List<PorezType>();
            this._pdv = new List<PorezType>();
            this._brRac = new BrojRacunaType();
        }

        /// <summary>
        /// Osobni identifikacijski broj obveznika fiskalizacije.
        /// </summary>
        public string Oib
        {
            get
            {
                return this._oib;
            }
            set
            {
                this._oib = value;
            }
        }

        /// <summary>
        /// U sustavu PDV. Oznaka je li obveznik fiskalizacije u sustavu PDV ili nije.
        /// </summary>
        public bool USustPdv
        {
            get
            {
                return this._uSustPdv;
            }
            set
            {
                this._uSustPdv = value;
            }
        }

        /// <summary>
        /// Datum i vrijeme izdavanja racuna koji se ispisuju na racunu.
        /// </summary>
        public string DatVrijeme
        {
            get
            {
                return this._datVrijeme;
            }
            set
            {
                this._datVrijeme = value;
            }
        }

        /// <summary>
        /// Oznaka slijednosti izdavanja racuna. Slijednost izdavanja racuna moze biti na razini poslovnog prostora ili naplatnog uredjaja.
        /// </summary>
        public OznakaSlijednostiType OznSlijed
        {
            get
            {
                return this._oznSlijed;
            }
            set
            {
                this._oznSlijed = value;
            }
        }

        /// <summary>
        /// Broj racuna.
        /// </summary>
        public BrojRacunaType BrRac
        {
            get
            {
                return this._brRac;
            }
            set
            {
                this._brRac = value;
            }
        }

        /// <summary>
        /// Porez na dodanu vrijednost.
        /// </summary>
        [System.Xml.Serialization.XmlArrayItemAttribute("Porez", IsNullable = false)]
        public List<PorezType> Pdv
        {
            get
            {
                return this._pdv;
            }
            set
            {
                this._pdv = value;
            }
        }

        /// <summary>
        /// Porez na potrosnju.
        /// </summary>
        [System.Xml.Serialization.XmlArrayItemAttribute("Porez", IsNullable = false)]
        public List<PorezType> Pnp
        {
            get
            {
                return this._pnp;
            }
            set
            {
                this._pnp = value;
            }
        }

        /// <summary>
        /// Ostali porezi.
        /// Navode se ostali porezi koji se mogu pojaviti na racunu osim PDV-a i poreza na potrosnju.
        /// Npr. porez na luksuz.
        /// </summary>
        [System.Xml.Serialization.XmlArrayItemAttribute("Porez", IsNullable = false)]
        public List<PorezOstaloType> OstaliPor
        {
            get
            {
                return this._ostaliPor;
            }
            set
            {
                this._ostaliPor = value;
            }
        }

        /// <summary>
        /// Iznos oslobodjenja na racunu.
        /// Ako se isporucuju dobra ili obavljaju usluge koje su oslobodjene od placanja PDV-a,
        /// potrebno je poslati ukupan iznos oslobodjenja na racunu.
        /// </summary>
        public string IznosOslobPdv
        {
            get
            {
                return this._iznosOslobPdv;
            }
            set
            {
                this._iznosOslobPdv = value;
            }
        }

        /// <summary>
        /// Iznos na koji se odnosi posebni postupka oporezivanja marze na racunu.
        /// Marza za rabljena dobra, umjetnicka djela, kolekcionarske ili antikne predmete (clanak 22.a Zakona o PDV-u).
        /// </summary>
        public string IznosMarza
        {
            get
            {
                return this._iznosMarza;
            }
            set
            {
                this._iznosMarza = value;
            }
        }

        /// <summary>
        /// Iznos koji ne podlijeze oporezivanju na racunu.
        /// </summary>
        public string IznosNePodlOpor
        {
            get
            {
                return this._iznosNePodlOpor;
            }
            set
            {
                this._iznosNePodlOpor = value;
            }
        }

        /// <summary>
        /// Naknade koje se mogu pojaviti na racunu tipa povratna naknada za ambalazu i sl.
        /// </summary>
        [System.Xml.Serialization.XmlArrayItemAttribute("Naknada", IsNullable = false)]
        public List<NaknadaType> Naknade
        {
            get
            {
                return this._naknade;
            }
            set
            {
                this._naknade = value;
            }
        }

        /// <summary>
        /// Ukupan iznos koji se iskazuje na racunu.
        /// </summary>
        public string IznosUkupno
        {
            get
            {
                return this._iznosUkupno;
            }
            set
            {
                this._iznosUkupno = value;
            }
        }

        /// <summary>
        /// Moguce vrijednosti su G - gotovina, K - kartice, C - cek,  T - transakcijski racun, O – ostalo.
        /// U slucaju vise nacina placanja po jednom racunu, isto je potrebno prijaviti pod O - ostalo.
        /// Za sve nacine placanja koji nisu propisani koristiti ce se oznaka O – ostalo.
        /// </summary>
        public NacinPlacanjaType NacinPlac
        {
            get
            {
                return this._nacinPlac;
            }
            set
            {
                this._nacinPlac = value;
            }
        }

        /// <summary>
        /// Osobni identifikacijski broj operatera na naplatnom uredjaju koji izdaje racun.
        /// </summary>
        public string OibOper
        {
            get
            {
                return this._oibOper;
            }
            set
            {
                this._oibOper = value;
            }
        }

        /// <summary>
        /// Zastitni kod izdavatelja.
        /// Zastitni kod izdavatelja obveznika fiskalizacije je alfanumericki zapis kojim se potvrdjuje veza izmedju obveznika fiskalizacije
        /// i izdanog racuna. Zastitni kod generira obveznik fiskalizacije.
        /// </summary>
        public string ZastKod
        {
            get
            {
                return this._zastKod;
            }
            set
            {
                this._zastKod = value;
            }
        }

        /// <summary>
        /// Oznaka naknadne dostave racuna.
        /// Obvezno se dostavlja u slucaju naknadne dostave racuna kad je isti prethodno izdan kupcu
        /// bez JIR-a (prekid Internet veze ili potpuni prestanak rada naplatnog uredjaja).
        /// </summary>
        public bool NakDost
        {
            get
            {
                return this._nakDost;
            }
            set
            {
                this._nakDost = value;
            }
        }

        /// <summary>
        /// Oznaka paragon racuna.
        /// Obavezno se dostavlja u slucaju potpunog prestanka rada naplatnog uredjaja kada obveznik fiskalizacije
        /// mora prepisati izdane paragon racune i prijaviti ih putem poruke Poreznoj upravi.
        /// </summary>
        public string ParagonBrRac
        {
            get
            {
                return this._paragonBrRac;
            }
            set
            {
                this._paragonBrRac = value;
            }
        }

        /// <summary>
        /// Specificna namjena.
        /// Predvidjeno za slucaj da se naknadno pojavi potreba za dostavom podataka koji nisu prepoznati tokom analize.
        /// </summary>
        public string SpecNamj
        {
            get
            {
                return this._specNamj;
            }
            set
            {
                this._specNamj = value;
            }
        }
    }

    /// <summary>
    /// Oznaka koja govori kako je dodijeljen broj racuna: N - na nivou naplatnog uredjaja , P - na nivou poslovnog prostora
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public enum OznakaSlijednostiType
    {

        N,

        P,
    }

    /// <summary>
    /// Nacini placanja: G - gotovina, K - kartice, C -
    /// cek, T - transakcijski racun, O - ostalo
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public enum NacinPlacanjaType
    {

        G,

        K,

        C,

        T,

        O,
    }

    /// <summary>
    /// Odgovor servisa za zaprimanje racuna.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = false)]
    public partial class RacunOdgovor : EntityBase<RacunOdgovor>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private ZaglavljeOdgovorType _zaglavlje;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _jir;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<GreskaType> _greske;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _id;

        /// <summary>
        /// RacunOdgovor class constructor
        /// </summary>
        public RacunOdgovor()
        {
            this._greske = new List<GreskaType>();
            this._zaglavlje = new ZaglavljeOdgovorType();
        }

        public ZaglavljeOdgovorType Zaglavlje
        {
            get
            {
                return this._zaglavlje;
            }
            set
            {
                this._zaglavlje = value;
            }
        }

        /// <summary>
        /// Jedinstveni identifikator racuna.
        /// </summary>
        public string Jir
        {
            get
            {
                return this._jir;
            }
            set
            {
                this._jir = value;
            }
        }

        [System.Xml.Serialization.XmlArrayItemAttribute("Greska", IsNullable = false)]
        public List<GreskaType> Greske
        {
            get
            {
                return this._greske;
            }
            set
            {
                this._greske = value;
            }
        }

        /// <summary>
        /// Atribut za potrebe digitalnog potpisa, u njega se stavlja referentni na koji se referencira digitalni potpis.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string Id
        {
            get
            {
                return this._id;
            }
            set
            {
                this._id = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class ZaglavljeOdgovorType : EntityBase<ZaglavljeOdgovorType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _idPoruke;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _datumVrijeme;

        /// <summary>
        /// Odabrati:
        /// Version 1 (MAC address) - ne koristiti
        /// Version 2 (DCE Security) - bazirano vremenskoj komponenti i
        /// domeni
        /// Version 3 (MD5 hash) - osnovni podaci generirano u
        /// ovisnosti
        /// o URLu, domeni i sl.
        /// Version 4 (random) - ne govori
        /// mnogo
        /// Version 5 (SHA-1 hash) - preferirano umjesto V3
        /// </summary>
        public string IdPoruke
        {
            get
            {
                return this._idPoruke;
            }
            set
            {
                this._idPoruke = value;
            }
        }

        /// <summary>
        /// Datum i vrijeme obrade poruke.
        /// </summary>
        public string DatumVrijeme
        {
            get
            {
                return this._datumVrijeme;
            }
            set
            {
                this._datumVrijeme = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class GreskaType : EntityBase<GreskaType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _sifraGreske;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _porukaGreske;

        public string SifraGreske
        {
            get
            {
                return this._sifraGreske;
            }
            set
            {
                this._sifraGreske = value;
            }
        }

        public string PorukaGreske
        {
            get
            {
                return this._porukaGreske;
            }
            set
            {
                this._porukaGreske = value;
            }
        }
    }

    /// <summary>
    /// Poruka prema web servisu za zaprimanje podataka o poslovnom prostoru.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = false)]
    public partial class PoslovniProstorZahtjev : EntityBase<PoslovniProstorZahtjev>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private ZaglavljeType _zaglavlje;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private PoslovniProstorType _poslovniProstor;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _id;

        /// <summary>
        /// PoslovniProstorZahtjev class constructor
        /// </summary>
        public PoslovniProstorZahtjev()
        {
            this._poslovniProstor = new PoslovniProstorType();
            this._zaglavlje = new ZaglavljeType();
        }

        public ZaglavljeType Zaglavlje
        {
            get
            {
                return this._zaglavlje;
            }
            set
            {
                this._zaglavlje = value;
            }
        }

        public PoslovniProstorType PoslovniProstor
        {
            get
            {
                return this._poslovniProstor;
            }
            set
            {
                this._poslovniProstor = value;
            }
        }

        /// <summary>
        /// Atribut za potrebe digitalnog potpisa, u njega se stavlja referentni na koji se referencira digitalni potpis.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string Id
        {
            get
            {
                return this._id;
            }
            set
            {
                this._id = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class PoslovniProstorType : EntityBase<PoslovniProstorType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _oib;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _oznPoslProstora;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private AdresniPodatakType _adresniPodatak;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _radnoVrijeme;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _datumPocetkaPrimjene;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private System.Nullable<OznakaZatvaranjaType> _oznakaZatvaranja;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _specNamj;

        /// <summary>
        /// PoslovniProstorType class constructor
        /// </summary>
        public PoslovniProstorType()
        {
            this._adresniPodatak = new AdresniPodatakType();
        }

        /// <summary>
        /// Osobni identifikacijski broj obveznika fiskalizacije.
        /// </summary>
        public string Oib
        {
            get
            {
                return this._oib;
            }
            set
            {
                this._oib = value;
            }
        }

        /// <summary>
        /// Oznaka poslovnog prostora.
        /// </summary>
        public string OznPoslProstora
        {
            get
            {
                return this._oznPoslProstora;
            }
            set
            {
                this._oznPoslProstora = value;
            }
        }

        /// <summary>
        /// Adresa ili opis poslovnog prostora ( npr. internet trgovina ) kada poslovni prostor nema adresu.
        /// </summary>
        public AdresniPodatakType AdresniPodatak
        {
            get
            {
                return this._adresniPodatak;
            }
            set
            {
                this._adresniPodatak = value;
            }
        }

        /// <summary>
        /// Radno vrijeme poslovnog prostora, slobodan unos.
        /// </summary>
        public string RadnoVrijeme
        {
            get
            {
                return this._radnoVrijeme;
            }
            set
            {
                this._radnoVrijeme = value;
            }
        }

        /// <summary>
        /// Datum otkad vrijedi promjena.
        /// </summary>
        public string DatumPocetkaPrimjene
        {
            get
            {
                return this._datumPocetkaPrimjene;
            }
            set
            {
                this._datumPocetkaPrimjene = value;
            }
        }

        /// <summary>
        /// Samo u slucaju da se zatvara poslovni prostor. Nakon zatvaranja poslovnog prostora ne smiju se vise prijavljivati racuni
        /// s oznakom tog poslovnog prostora.
        /// </summary>
        public OznakaZatvaranjaType OznakaZatvaranja
        {
            get
            {
                if (this._oznakaZatvaranja.HasValue)
                {
                    return this._oznakaZatvaranja.Value;
                }
                else
                {
                    return default(OznakaZatvaranjaType);
                }
            }
            set
            {
                this._oznakaZatvaranja = value;
            }
        }

        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool OznakaZatvaranjaSpecified
        {
            get
            {
                return this._oznakaZatvaranja.HasValue;
            }
            set
            {
                if (value == false)
                {
                    this._oznakaZatvaranja = null;
                }
            }
        }

        /// <summary>
        /// Potrebno je dostaviti jedan od podataka u nastavku:
        /// - OIB pravne ili fizicke osobe koja je proizvela programsko rjesenje ili
        /// - OIB pravne ili fizicke osobe koja odrzava programsko rjesenje ili
        /// - OIB pravne ili fizicke osobe prodavatelja u slucaju da se koristi rjesenje od stranog proizvodaca – bez lokalnog partnera
        /// </summary>
        public string SpecNamj
        {
            get
            {
                return this._specNamj;
            }
            set
            {
                this._specNamj = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class AdresniPodatakType : EntityBase<AdresniPodatakType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private object _item;

        [System.Xml.Serialization.XmlElementAttribute("Adresa", typeof(AdresaType))]
        [System.Xml.Serialization.XmlElementAttribute("OstaliTipoviPP", typeof(string))]
        public object Item
        {
            get
            {
                return this._item;
            }
            set
            {
                this._item = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public partial class AdresaType : EntityBase<AdresaType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _ulica;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _kucniBroj;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _kucniBrojDodatak;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _brojPoste;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _naselje;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _opcina;

        public string Ulica
        {
            get
            {
                return this._ulica;
            }
            set
            {
                this._ulica = value;
            }
        }

        public string KucniBroj
        {
            get
            {
                return this._kucniBroj;
            }
            set
            {
                this._kucniBroj = value;
            }
        }

        public string KucniBrojDodatak
        {
            get
            {
                return this._kucniBrojDodatak;
            }
            set
            {
                this._kucniBrojDodatak = value;
            }
        }

        public string BrojPoste
        {
            get
            {
                return this._brojPoste;
            }
            set
            {
                this._brojPoste = value;
            }
        }

        public string Naselje
        {
            get
            {
                return this._naselje;
            }
            set
            {
                this._naselje = value;
            }
        }

        public string Opcina
        {
            get
            {
                return this._opcina;
            }
            set
            {
                this._opcina = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    public enum OznakaZatvaranjaType
    {

        Z,
    }

    /// <summary>
    /// Odgovor servisa za zaprimanje podataka o poslovnom prostoru.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = false)]
    public partial class PoslovniProstorOdgovor : EntityBase<PoslovniProstorOdgovor>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private ZaglavljeOdgovorType _zaglavlje;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<GreskaType> _greske;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _id;

        /// <summary>
        /// PoslovniProstorOdgovor class constructor
        /// </summary>
        public PoslovniProstorOdgovor()
        {
            this._greske = new List<GreskaType>();
            this._zaglavlje = new ZaglavljeOdgovorType();
        }

        public ZaglavljeOdgovorType Zaglavlje
        {
            get
            {
                return this._zaglavlje;
            }
            set
            {
                this._zaglavlje = value;
            }
        }

        [System.Xml.Serialization.XmlArrayItemAttribute("Greska", IsNullable = false)]
        public List<GreskaType> Greske
        {
            get
            {
                return this._greske;
            }
            set
            {
                this._greske = value;
            }
        }

        /// <summary>
        /// Atribut za potrebe digitalnog potpisa, u njega se stavlja referentni na koji se referencira digitalni potpis.
        /// </summary>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string Id
        {
            get
            {
                return this._id;
            }
            set
            {
                this._id = value;
            }
        }
    }

    /// <summary>
    /// Poruka prema web servisu za provjeru racuna.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = false)]
    public partial class ProvjeraZahtjev : EntityBase<ProvjeraZahtjev>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private ZaglavljeType _zaglavlje;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private RacunType _racun;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _id;

        /// <summary>
        /// ProvjeraZahtjev class constructor
        /// </summary>
        public ProvjeraZahtjev()
        {
            this._racun = new RacunType();
            this._zaglavlje = new ZaglavljeType();
        }

        public ZaglavljeType Zaglavlje
        {
            get
            {
                return this._zaglavlje;
            }
            set
            {
                this._zaglavlje = value;
            }
        }

        public RacunType Racun
        {
            get
            {
                return this._racun;
            }
            set
            {
                this._racun = value;
            }
        }

        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string Id
        {
            get
            {
                return this._id;
            }
            set
            {
                this._id = value;
            }
        }
    }

    /// <summary>
    /// Odgovor servisa za provjeru racuna.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = false)]
    public partial class ProvjeraOdgovor : EntityBase<ProvjeraOdgovor>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private ZaglavljeOdgovorType _zaglavlje;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private RacunType _racun;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<GreskaType> _greske;

        [EditorBrowsable(EditorBrowsableState.Never)]
        private string _id;

        /// <summary>
        /// ProvjeraOdgovor class constructor
        /// </summary>
        public ProvjeraOdgovor()
        {
            this._greske = new List<GreskaType>();
            this._racun = new RacunType();
            this._zaglavlje = new ZaglavljeOdgovorType();
        }

        public ZaglavljeOdgovorType Zaglavlje
        {
            get
            {
                return this._zaglavlje;
            }
            set
            {
                this._zaglavlje = value;
            }
        }

        public RacunType Racun
        {
            get
            {
                return this._racun;
            }
            set
            {
                this._racun = value;
            }
        }

        [System.Xml.Serialization.XmlArrayItemAttribute("Greska", IsNullable = false)]
        public List<GreskaType> Greske
        {
            get
            {
                return this._greske;
            }
            set
            {
                this._greske = value;
            }
        }

        [System.Xml.Serialization.XmlAttributeAttribute()]
        public string Id
        {
            get
            {
                return this._id;
            }
            set
            {
                this._id = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = true)]
    public partial class PdvType : EntityBase<PdvType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<PorezType> porezField;

        /// <summary>
        /// PdvType class constructor
        /// </summary>
        public PdvType()
        {
            this.porezField = new List<PorezType>();
        }

        [System.Xml.Serialization.XmlElementAttribute("Porez", Order = 0)]
        public List<PorezType> Porez
        {
            get
            {
                return this.porezField;
            }
            set
            {
                this.porezField = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = true)]
    public partial class PorezNaPotrosnjuType : EntityBase<PorezNaPotrosnjuType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<PorezType> porezField;

        /// <summary>
        /// PorezNaPotrosnjuType class constructor
        /// </summary>
        public PorezNaPotrosnjuType()
        {
            this.porezField = new List<PorezType>();
        }

        [System.Xml.Serialization.XmlElementAttribute("Porez", Order = 0)]
        public List<PorezType> Porez
        {
            get
            {
                return this.porezField;
            }
            set
            {
                this.porezField = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = true)]
    public partial class GreskeType : EntityBase<GreskeType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<GreskaType> greskaField;

        /// <summary>
        /// GreskeType class constructor
        /// </summary>
        public GreskeType()
        {
            this.greskaField = new List<GreskaType>();
        }

        [System.Xml.Serialization.XmlElementAttribute("Greska", Order = 0)]
        public List<GreskaType> Greska
        {
            get
            {
                return this.greskaField;
            }
            set
            {
                this.greskaField = value;
            }
        }
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Xml", "4.6.1064.2")]
    [System.SerializableAttribute()]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73")]
    [System.Xml.Serialization.XmlRootAttribute(Namespace = "http://www.apis-it.hr/fin/2012/types/f73", IsNullable = true)]
    public partial class OstaliPoreziType : EntityBase<OstaliPoreziType>
    {

        [EditorBrowsable(EditorBrowsableState.Never)]
        private List<PorezOstaloType> porezField;

        /// <summary>
        /// OstaliPoreziType class constructor
        /// </summary>
        public OstaliPoreziType()
        {
            this.porezField = new List<PorezOstaloType>();
        }

        [System.Xml.Serialization.XmlElementAttribute("Porez", Order = 0)]
        public List<PorezOstaloType> Porez
        {
            get
            {
                return this.porezField;
            }
            set
            {
                this.porezField = value;
            }
        }
    }
}
#pragma warning restore
