﻿using System;
using System.IO;
using System.Net;
using System.Text;

namespace Service_Manager.CIS.Requests
{
    public class DotNetRequest : Request
    {
        public bool send(string data, string url, int timeout, out string response)
        {

            Uri uri = null;

            if (!string.IsNullOrEmpty(url))
                uri = new Uri(url);

            // - DK -
            // TLS1.2 and TLS1.1 integration
            // ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12 | SecurityProtocolType.Tls11;
            ///////////////////

            response = null;
            HttpWebRequest request = WebRequest.Create(uri) as HttpWebRequest;
            if (request != null)
            {
                //ServicePointManager.Expect100Continue = true; //http://msdn.microsoft.com/query/dev10.query?appId=Dev10IDEF1&l=EN-US&k=k(SYSTEM.NET.SERVICEPOINTMANAGER.EXPECT100CONTINUE)&rd=true


                request.Timeout = timeout;

                request.ContentType = "text/xml";
                request.Method = "POST";

                //request.Headers = new WebHeaderCollection();
                //request.Headers.Add("SOAPAction", webMethod);


                byte[] by = UTF8Encoding.UTF8.GetBytes(data);
                request.ProtocolVersion = HttpVersion.Version11;
                request.ContentLength = by.Length;


                using (Stream requestStream = request.GetRequestStream())
                {
                    requestStream.Write(by, 0, by.Length);
                }

                HttpWebResponse webResponse = request.GetResponse() as HttpWebResponse;
                if (webResponse != null)
                {
                    Stream responseStream = webResponse.GetResponseStream();
                    Encoding encode = Encoding.GetEncoding("utf-8");
                    StreamReader readStream = new StreamReader(responseStream, encode);
                    response = readStream.ReadToEnd();
                    return true;
                }
            }
            return false;
        }
    }
}
