﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;

namespace Service_Manager.CIS.Requests
{
    public class CurlWebRequest : Request
    {
        private string _PemFile = null;
        public CurlWebRequest(string pemFile)
        {
            _PemFile = pemFile;
        }
        private string returnData = string.Empty;

        public bool send(string data, string url, int timeout, out string response)
        {
            string dataFile = "data.xml";

            MessageBox.Show("Curl.send metoda - File dio");

            if (File.Exists(dataFile))
                File.Delete(dataFile);
            File.Create(dataFile).Close();

            MessageBox.Show("StreamWriter");

            using (StreamWriter streamWriter = File.AppendText(dataFile))
            {
                streamWriter.Write(data);
            }

            MessageBox.Show("Proccesss start info");

            ProcessStartInfo startInfo = new ProcessStartInfo();
            startInfo.CreateNoWindow = true;
            startInfo.UseShellExecute = false;
            MessageBox.Show("Lokacija curla");
            startInfo.FileName = IzvuciLokacijuCurla();
            MessageBox.Show(startInfo.FileName);

            startInfo.WindowStyle = ProcessWindowStyle.Hidden;
            startInfo.RedirectStandardError = true;
            startInfo.RedirectStandardOutput = true;
            startInfo.Arguments = "--header \"Content-Type: text/xml\" --data @" + dataFile + " --cacert " + _PemFile + " -k " + url;
            string output = string.Empty;
            string error = string.Empty;

            try
            {

                MessageBox.Show("Pokrećem curl "+Environment.NewLine+startInfo.FileName);

                using (Process exeProcess = Process.Start(startInfo))
                {
                    output = exeProcess.StandardOutput.ReadToEnd();
                    //Curl u error ne baca pametne stvari, pa ovo nije ni potrebno
                    error = exeProcess.StandardError.ReadToEnd();
                    exeProcess.WaitForExit();

                }
            }
            catch (Exception ex)
            {
                response = output;
                return false;

            }
            response = output;
            if (output.Contains("tns:Greska"))
                throw new CurlException("Greška u podacima", response);

            if (output != string.Empty)
            {
                return true;
            }
            return false;



        }

        private string IzvuciLokacijuCurla()
        {
            string lokacija = Application.ExecutablePath;
            for(int i=0;i<3;i++)
            {
                lokacija = BrisiOdCrteDoKraja(lokacija);
            }
            lokacija += "\\CIS\\curl.exe";
            return lokacija;
        }

        private string BrisiOdCrteDoKraja(string lokacija)
        {
            return lokacija = lokacija.Remove(lokacija.LastIndexOf("\\"), lokacija.Length - lokacija.LastIndexOf("\\"));
        }
    }

    public class CurlException : Exception
    {
        public string Response { get; set; }
        public CurlException(string message, string response) : base(message)
        {
            Response = response;
        }
    }
}
