﻿using System;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;
using System.IO;
using System.Diagnostics;
using System.Text;

namespace Service_Manager.CIS.Popratne_funkcije
{
    public static class Razno
    {
        public static string FormatirajDatumVrijeme(DateTime datumVrijeme)
        {
            return String.Format("{0:dd.MM.yyyy}T{1}", datumVrijeme, datumVrijeme.ToString("HH:mm:ss"));
        }

        public static string FormatirajDatum(DateTime datum)
        {
            return String.Format("{0:dd.MM.yyyy}", datum);
        }

        public static string DohvatiFormatiranoTrenutnoDatumVrijeme()
        {
            return FormatirajDatumVrijeme(DateTime.Now);
        }

        public static void FormatirajEchoPoruku(ref string poruka)
        {
            if (string.IsNullOrEmpty(poruka))
                poruka = "echo test";
        }

        public static string ZastitniKodIzracun(X509Certificate2 certifikat, string oibObveznika, string datumVrijemeIzdavanjaRacuna, string brojcanaOznakaRacuna, string oznakaPoslovnogProstora, string oznakaNaplatnogUredaja, string ukupniIznosRacuna)
        {
            if (certifikat == null || string.IsNullOrEmpty(oibObveznika) || datumVrijemeIzdavanjaRacuna == null || string.IsNullOrEmpty(brojcanaOznakaRacuna) || string.IsNullOrEmpty(oznakaPoslovnogProstora) || string.IsNullOrEmpty(oznakaNaplatnogUredaja))
                throw new ArgumentNullException();


            return ZKI(certifikat, oibObveznika, datumVrijemeIzdavanjaRacuna, brojcanaOznakaRacuna, oznakaPoslovnogProstora, oznakaNaplatnogUredaja, ukupniIznosRacuna);
        }

        public static string ZastitniKodIzracun(string certificateSubject, string oibObveznika, string datumVrijemeIzdavanjaRacuna, string brojcanaOznakaRacuna, string oznakaPoslovnogProstora, string oznakaNaplatnogUredaja, string ukupniIznosRacuna)
        {
            if (string.IsNullOrEmpty(certificateSubject) || string.IsNullOrEmpty(oibObveznika) || datumVrijemeIzdavanjaRacuna == null || string.IsNullOrEmpty(brojcanaOznakaRacuna) || string.IsNullOrEmpty(oznakaPoslovnogProstora) || string.IsNullOrEmpty(oznakaNaplatnogUredaja))
                throw new ArgumentNullException();


            X509Certificate2 certificate = Potpisivanje.DohvatiCertifikat(certificateSubject);

            return ZKI(certificate, oibObveznika, datumVrijemeIzdavanjaRacuna, brojcanaOznakaRacuna, oznakaPoslovnogProstora, oznakaNaplatnogUredaja, ukupniIznosRacuna);
        }

        public static string ZastitniKodIzracun(string certifikatDatoteka, string zaporka, string oibObveznika, string datumVrijemeIzdavanjaRacuna, string brojcanaOznakaRacuna, string oznakaPoslovnogProstora, string oznakaNaplatnogUredaja, string ukupniIznosRacuna)
        {
            if (string.IsNullOrEmpty(certifikatDatoteka) || string.IsNullOrEmpty(zaporka) || string.IsNullOrEmpty(oibObveznika) || datumVrijemeIzdavanjaRacuna == null || string.IsNullOrEmpty(brojcanaOznakaRacuna) || string.IsNullOrEmpty(oznakaPoslovnogProstora) || string.IsNullOrEmpty(oznakaNaplatnogUredaja))
                throw new ArgumentNullException();


            X509Certificate2 certificate = Potpisivanje.DohvatiCertifikat(certifikatDatoteka, zaporka);

            return ZKI(certificate, oibObveznika, datumVrijemeIzdavanjaRacuna, brojcanaOznakaRacuna, oznakaPoslovnogProstora, oznakaNaplatnogUredaja, ukupniIznosRacuna);
        }

        public static DirectoryInfo GenerirajProvjeriMapu(string mapa)
        {
            DirectoryInfo di = null;
            try
            {
                di = new DirectoryInfo(mapa);
                if (!di.Exists)
                    di.Create();
            }
            catch (Exception ex)
            {
                Trace.TraceError(String.Format("Greška kod kreiranja mape:{0}", ex.Message));
                throw;
            }

            return di;
        }



        #region Private
        // Preuzeto sa http://www.codeproject.com/Articles/21312/Generating-MD5-Hash-out-of-C-Objects
        private static string ComputeHash(byte[] objectAsBytes)
        {
            //MD5 md5 =  new MD5CryptoServiceProvider();
            MD5 md5 = MD5.Create();
            try
            {
                byte[] result = md5.ComputeHash(objectAsBytes);

                // Build the final string by converting each byte
                // into hex and appending it to a StringBuilder
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < result.Length; i++)
                {
                    sb.Append(result[i].ToString("x2"));
                }

                // And return it
                return sb.ToString();
            }
            catch (ArgumentNullException ane)
            {
                //If something occurred during serialization, 
                //this method is called with a null argument. 
                Console.WriteLine("Hash has not been generated.");
                return null;
            }
        }

        private static string ZKI(X509Certificate2 certifikat, string oibObveznika, string datumVrijemeIzdavanjaRacuna, string brojcanaOznakaRacuna, string oznakaPoslovnogProstora, string oznakaNaplatnogUredaja, string ukupniIznosRacuna)
        {
            string zastitniKod;

            StringBuilder sb = new StringBuilder();
            sb.Append(oibObveznika);
            sb.Append(datumVrijemeIzdavanjaRacuna);
            sb.Append(brojcanaOznakaRacuna);
            sb.Append(oznakaPoslovnogProstora);
            sb.Append(oznakaNaplatnogUredaja);
            sb.Append(ukupniIznosRacuna.Replace(',', '.'));

            byte[] by = Potpisivanje.PotpisiTekst(sb.ToString(), certifikat);
            if (by != null)
                zastitniKod = ComputeHash(by);
            else
                zastitniKod = "";


            return zastitniKod;
        }
        #endregion
    }
}
