﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Security.Cryptography.X509Certificates;
using System.Xml;
using System.Windows.Forms;

namespace Service_Manager
{
    class Fiskalizacija
    {
       
        //ZKI JE DODAN SAMO ZA NAKNADNU FISKALIZACIJU DA FISKALIZIRA SA VEĆ IZRAĐENIM ZKI-EM
        public static Dokument FiskalizirajRacun(ProgramSettings settings, CIS.Schema.RacunType racun,string ZKI)
        {
            Dokument d = new Dokument();

            X509Certificate2 certifikat = CertificateFile(settings.CertifikatPutanja, settings.CertifikatPassword);
            if (certifikat == null)
            {
                MessageBox.Show("Certifikat nije pronađen ! ");
            }
            else
            {
                if (ZKI == "")
                {
                    try
                    {
                        racun.ZastKod = CIS.Popratne_funkcije.Razno.ZastitniKodIzracun(certifikat, racun.Oib, racun.DatVrijeme.Replace('T', ' '), racun.BrRac.BrOznRac, racun.BrRac.OznPosPr, racun.BrRac.OznNapUr, racun.IznosUkupno.ToString());
                        MessageBox.Show("ZKI izračunat " + racun.ZastKod);
                    }
                    catch(Exception x)
                    {
                        MessageBox.Show("Greška prilikom izračuna zaštitnog koda računa ( ZKI ) ");
                    }
                }
                else
                {
                    racun.ZastKod = ZKI;
                }

                XmlDocument ret = null;
                string jir = string.Empty;
                try
                {
                    CIS.CentralniInformacijskiSustav cis = new CIS.CentralniInformacijskiSustav() { TimeOut = settings.Timeout };
                    cis.CisUrl = settings.UrlServisa;
                    cis.PemPath = settings.PemFile;

                    MessageBox.Show("Slanje računa");
                    ret = cis.PosaljiRacun(racun, certifikat);
                    MessageBox.Show("Dohvaćanje JIR-a");
                    jir = CIS.Popratne_funkcije.XmlDokumenti.DohvatiJir(ret);
                    MessageBox.Show("JIR uspješno dobiven " + jir);

                }
                catch (Exception e)
                {
                    MessageBox.Show("Greška prilikom fiskalizacije" + Environment.NewLine + Environment.NewLine + e.Message);
                }
                d.JIR = jir;
                d.ZKI = racun.ZastKod;
            }
            return d;
        }

        private static X509Certificate2 CertificateFile(string certifikatDatoteka, string zaporka)
        {
            X509Certificate2 certifikat = null;

            if (string.IsNullOrEmpty(certifikatDatoteka))
            {
                Console.WriteLine("Datoteka sa certifikatom mora biti postavljena.");
            }

            if (string.IsNullOrEmpty(zaporka))
            {
                Console.WriteLine("Lozinka za certifikat mora biti postavljena.");
            }


            try
            {
                certifikat = CIS.Popratne_funkcije.Potpisivanje.DohvatiCertifikat(certifikatDatoteka, zaporka);
            }
            catch (Exception ex)
            {
                Console.WriteLine(String.Format("Greška kod dohvata certifikata: {0}", ex.Message));
            }


            return certifikat;
        }
    }
}
